/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Item;

public abstract class Screen
extends Displayable {
    static final Font CONTENT_FONT = Font.getDefaultFont();
    static final int CONTENT_HEIGHT = CONTENT_FONT.getHeight();
    int paintBorder;
    static final int BORDER_NONE = 0;
    static final int BORDER_SOLID = 1;
    static final int BORDER_GRAY = 2;
    static final boolean SCROLLS_HORIZONTAL = false;
    static final boolean SCROLLS_VERTICAL = true;
    int[] view = new int[4];
    boolean resetToTop = true;

    Screen() {
        this(null);
    }

    Screen(String title) {
        this.view[0] = 0;
        this.view[1] = 0;
        this.view[2] = 0;
        this.view[3] = 0;
        super.setTitleImpl(title);
    }

    void layout() {
        super.layout();
        this.translateViewport();
    }

    void repaintItem(Item item, int x, int y, int w, int h) {
        this.callRepaint(item.bounds[0] + this.viewport[0] - this.view[0] + x, item.bounds[1] + this.viewport[1] - this.view[1] + y, w, h, item);
    }

    private void translateViewport() {
        if (this.paintBorder != 0) {
            this.viewport[0] = this.viewport[0] + 4;
            this.viewport[1] = this.viewport[1] + 4;
            this.viewport[2] = this.viewport[2] - 8;
            this.viewport[3] = this.viewport[3] - 8;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void callPaint(Graphics g, Object target) {
        super.callPaint(g, target);
        Object object = Display.LCDUILock;
        synchronized (object) {
            if (this.paintBorder != 0 && g.getClipX() < this.viewport[0]) {
                g.setColor(Display.ERASE_COLOR);
                g.drawRect(this.viewport[0] - 4, this.viewport[1] - 4, this.viewport[2] + 7, this.viewport[3] + 7);
                g.drawRect(this.viewport[0] - 3, this.viewport[1] - 3, this.viewport[2] + 5, this.viewport[3] + 5);
                g.drawRect(this.viewport[0] - 2, this.viewport[1] - 2, this.viewport[2] + 3, this.viewport[3] + 3);
                g.drawRect(this.viewport[0] - 1, this.viewport[1] - 1, this.viewport[2] + 1, this.viewport[3] + 1);
                if (this.paintBorder == 1) {
                    g.setColor(Display.FG_COLOR);
                } else {
                    g.setColor(0xAFAFAF);
                    g.setStrokeStyle(1);
                }
                g.drawRect(this.viewport[0] - 3, this.viewport[1] - 3, this.viewport[2] + 5, this.viewport[3] + 5);
                g.setStrokeStyle(0);
            }
            g.clipRect(this.viewport[0], this.viewport[1], this.viewport[2], this.viewport[3]);
            if (target == null || target instanceof Item && ((Item)target).owner == this) {
                g.setColor(Display.ERASE_COLOR);
                g.fillRect(g.getClipX(), g.getClipY(), g.getClipWidth(), g.getClipHeight());
                g.setColor(Display.FG_COLOR);
            }
        }
    }

    void setVerticalScroll() {
        if (this.view[3] <= this.viewport[3]) {
            super.setVerticalScroll(0, 100);
        } else {
            super.setVerticalScroll(this.view[1] * 100 / (this.view[3] - this.viewport[3]), this.viewport[3] * 100 / this.view[3]);
        }
    }
}

