/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.media;

import com.sun.mmedia.BasicPlayer;
import com.sun.mmedia.Configuration;
import com.sun.mmedia.PermissionAccessor;
import com.sun.mmedia.TonePlayer;
import com.sun.mmedia.protocol.BasicDS;
import com.sun.mmedia.protocol.CommonDS;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.SystemTimeBase;
import javax.microedition.media.TimeBase;
import javax.microedition.media.protocol.DataSource;

public final class Manager {
    private static Configuration config = Configuration.getConfiguration();
    private static TonePlayer tonePlayer;
    private static TimeBase sysTimeBase;
    private static Object createLock;
    public static final String TONE_DEVICE_LOCATOR = "device://tone";
    public static final String MIDI_DEVICE_LOCATOR = "device://midi";
    private static final String DS_ERR = "Cannot create a DataSource for: ";
    private static final String PL_ERR = "Cannot create a Player for: ";
    private static final String REDIRECTED_MSG = " with exception message: ";

    private Manager() {
    }

    public static String[] getSupportedContentTypes(String protocol) {
        return config.getSupportedContentTypes(protocol);
    }

    public static String[] getSupportedProtocols(String content_type) {
        return config.getSupportedProtocols(content_type);
    }

    public static Player createPlayer(String locator) throws IOException, MediaException {
        String locStr;
        block17: {
            String validLoc;
            block16: {
                if (locator == null) {
                    throw new IllegalArgumentException();
                }
                locStr = locator.toLowerCase();
                validLoc = TONE_DEVICE_LOCATOR;
                if (locStr.equals(TONE_DEVICE_LOCATOR)) break block16;
                validLoc = MIDI_DEVICE_LOCATOR;
                if (locStr.equals(MIDI_DEVICE_LOCATOR)) break block16;
                validLoc = "capture://radio";
                if (locStr.startsWith("capture://radio")) break block16;
                validLoc = "capture://video";
                if (!locStr.startsWith("capture://video")) break block17;
            }
            int encInd = locator.indexOf(63);
            String encStr = null;
            if (encInd > 0) {
                encStr = locator.substring(encInd + 1);
                locStr = locStr.substring(0, encInd);
            } else {
                if (locStr.length() != validLoc.length()) {
                    throw new MediaException("Malformed locator");
                }
                encStr = "";
            }
            String className = config.getHandler(locStr);
            try {
                Class<?> protoClass = Class.forName(className);
                BasicPlayer p = (BasicPlayer)protoClass.newInstance();
                if (!p.initFromURL(encStr)) {
                    throw new MediaException("Invalid locator media encodings");
                }
                return p;
            }
            catch (Exception e) {
                throw new MediaException(PL_ERR + locator + REDIRECTED_MSG + e.getMessage());
            }
        }
        String theProtocol = null;
        int idx = locStr.indexOf(58);
        if (idx == -1) {
            throw new MediaException("Malformed locator");
        }
        theProtocol = locStr.substring(0, idx);
        String[] supported = Manager.getSupportedProtocols(config.ext2Mime(locStr));
        boolean found = false;
        for (int i = 0; i < supported.length; ++i) {
            if (!theProtocol.equals(supported[i])) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new MediaException(PL_ERR + locator);
        }
        DataSource ds = Manager.createDataSource(locator);
        Player pp = null;
        try {
            pp = Manager.createPlayer(ds);
        }
        catch (MediaException ex) {
            ds.disconnect();
            throw ex;
        }
        catch (IOException ex) {
            ds.disconnect();
            throw ex;
        }
        return pp;
    }

    public static Player createPlayer(InputStream stream, String type) throws IOException, MediaException {
        if (stream == null) {
            throw new IllegalArgumentException();
        }
        if (type == null) {
            throw new MediaException("Cannot create a Player for: NULL content-type");
        }
        type = type.toLowerCase();
        CommonDS ds = new CommonDS();
        ds.setInputStream(stream);
        ds.setContentType(type);
        try {
            return Manager.createPlayer(ds);
        }
        catch (IOException ex) {
            throw new MediaException(PL_ERR + ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void playTone(int note, int duration, int volume) throws MediaException {
        if (note < 0 || note > 127 || duration <= 0) {
            throw new IllegalArgumentException("bad param");
        }
        if (duration == 0 || volume == 0) {
            return;
        }
        Object object = createLock;
        synchronized (object) {
            if (tonePlayer == null) {
                tonePlayer = config.getTonePlayer();
            }
        }
        if (tonePlayer == null) {
            throw new MediaException("no tone player");
        }
        tonePlayer.playTone(note, duration, volume);
    }

    private static BasicPlayer getPlayerFromType(String type) throws IOException, MediaException {
        if (type == null) {
            throw new MediaException("Cannot create a Player for: NULL content-type");
        }
        String className = config.getHandler(type);
        if (className == null) {
            throw new MediaException(PL_ERR + type);
        }
        BasicPlayer p = null;
        try {
            Class<?> handlerClass = Class.forName(className);
            p = (BasicPlayer)handlerClass.newInstance();
        }
        catch (Exception e) {
            throw new MediaException(PL_ERR + type + REDIRECTED_MSG + e.getMessage());
        }
        return p;
    }

    public static Player createPlayer(DataSource source) throws IOException, MediaException {
        if (source == null) {
            throw new IllegalArgumentException();
        }
        source.connect();
        String contentType = source.getContentType();
        String locator = source.getLocator();
        PermissionAccessor.checkContentTypePermissions(locator, contentType);
        BasicPlayer p = Manager.getPlayerFromType(contentType);
        p.setSource(source);
        return p;
    }

    private static DataSource createDataSource(String locator) throws IOException, MediaException {
        String className = config.getHandler(BasicDS.getProtocol(locator));
        if (className == null) {
            throw new MediaException(DS_ERR + locator);
        }
        PermissionAccessor.checkLocatorPermissions(locator);
        try {
            Class<?> protoClass = Class.forName(className);
            DataSource source = (DataSource)protoClass.newInstance();
            ((BasicDS)source).setLocator(locator);
            source.connect();
            return source;
        }
        catch (IOException e) {
            throw e;
        }
        catch (MediaException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MediaException(DS_ERR + locator + REDIRECTED_MSG + e.getMessage());
        }
    }

    public static TimeBase getSystemTimeBase() {
        return sysTimeBase;
    }

    static {
        sysTimeBase = new SystemTimeBase();
        createLock = new Object();
    }
}

