/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.securityservice;

import com.sun.midp.main.Configuration;
import com.sun.midp.midlet.Scheduler;
import com.sun.satsa.pki.PKIManager;
import javax.microedition.pki.UserCredentialManagerException;
import javax.microedition.securityservice.CMSMessageSignatureServiceException;

public final class CMSMessageSignatureService {
    public static final int SIG_INCLUDE_CONTENT = 1;
    public static final int SIG_INCLUDE_CERTIFICATE = 2;
    static int mask = -4;
    private static boolean opaqueSig = false;
    private static boolean certSig = false;

    private CMSMessageSignatureService() {
    }

    public static final byte[] sign(String stringToSign, int options, String[] caNames, String securityElementPrompt) throws CMSMessageSignatureServiceException, UserCredentialManagerException {
        CMSMessageSignatureService.checkOptions(options);
        return PKIManager.sign((int)2, null, (String)stringToSign, (int)options, (String[])caNames, (String)securityElementPrompt);
    }

    public static final byte[] authenticate(byte[] byteArrayToAuthenticate, int options, String[] caNames, String securityElementPrompt) throws CMSMessageSignatureServiceException, UserCredentialManagerException {
        try {
            Scheduler.getScheduler().getMIDletSuite().checkForPermission(45, null);
        }
        catch (InterruptedException ie) {
            throw new SecurityException("Interrupted while trying to ask the user permission");
        }
        CMSMessageSignatureService.checkOptions(options);
        return PKIManager.sign((int)0, (byte[])byteArrayToAuthenticate, null, (int)options, (String[])caNames, (String)securityElementPrompt);
    }

    public static final byte[] authenticate(String stringToAuthenticate, int options, String[] caNames, String securityElementPrompt) throws CMSMessageSignatureServiceException, UserCredentialManagerException {
        CMSMessageSignatureService.checkOptions(options);
        return PKIManager.sign((int)1, null, (String)stringToAuthenticate, (int)options, (String[])caNames, (String)securityElementPrompt);
    }

    static void checkOptions(int options) throws CMSMessageSignatureServiceException {
        if ((options & mask) != 0) {
            throw new IllegalArgumentException("Invalid signing options ");
        }
        if ((options & 1) == 1 && !opaqueSig) {
            throw new CMSMessageSignatureServiceException(4);
        }
        if ((options & 2) == 2 && !certSig) {
            throw new CMSMessageSignatureServiceException(8);
        }
    }

    static {
        String signprop = Configuration.getProperty("com.sun.satsa.opaquesig");
        if (signprop != null) {
            opaqueSig = signprop.equals("true");
        }
        if ((signprop = Configuration.getProperty("com.sun.satsa.certsig")) != null) {
            certSig = signprop.equals("true");
        }
    }
}

