/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.securityservice;

public final class CMSMessageSignatureServiceException
extends Exception {
    public static final byte CRYPTO_FAILURE = 1;
    public static final byte CRYPTO_FORMAT_ERROR = 2;
    public static final byte CRYPTO_NO_DETACHED_SIG = 3;
    public static final byte CRYPTO_NO_OPAQUE_SIG = 4;
    public static final byte SE_BUSY = 5;
    public static final byte SE_FAILURE = 6;
    public static final byte SE_CRYPTO_FAILURE = 7;
    public static final byte CRYPTO_NO_CERTIFICATE = 8;
    private byte reasonCode;

    public CMSMessageSignatureServiceException(byte code) {
        super(CMSMessageSignatureServiceException.getMessageForReason(code));
        this.reasonCode = code;
    }

    public byte getReason() {
        return this.reasonCode;
    }

    static String getMessageForReason(int reason) {
        switch (reason) {
            case 1: {
                return "Failed to perform cryptographic function";
            }
            case 2: {
                return "Formatting error during cryptographic processing";
            }
            case 3: {
                return "Detached signatures not supported";
            }
            case 4: {
                return "Opaque signatures not supported";
            }
            case 5: {
                return "Security element is busy";
            }
            case 6: {
                return "Security element failure";
            }
            case 7: {
                return "Security element failed cryptographic request";
            }
            case 8: {
                return "Certificate was not found for cryptographic operation";
            }
        }
        return "Unknown reason (" + reason + ")";
    }
}

