/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.m3g;

import java.util.Hashtable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.m3g.Appearance;
import javax.microedition.m3g.Background;
import javax.microedition.m3g.Camera;
import javax.microedition.m3g.Engine;
import javax.microedition.m3g.Image2D;
import javax.microedition.m3g.IndexBuffer;
import javax.microedition.m3g.Light;
import javax.microedition.m3g.Node;
import javax.microedition.m3g.Transform;
import javax.microedition.m3g.VertexBuffer;
import javax.microedition.m3g.World;

public class Graphics3D {
    int swerveHandle;
    public static final int ANTIALIAS = 2;
    public static final int DITHER = 4;
    public static final int TRUE_COLOR = 8;
    public static final int OVERWRITE = 16;
    static final int SUPPORTANTIALIASING = 0;
    static final int SUPPORTTRUECOLOR = 1;
    static final int SUPPORTDITHERING = 2;
    static final int SUPPORTMIPMAP = 3;
    static final int SUPPORTPERSPECTIVECORRECTION = 4;
    static final int SUPPORTLOCALCAMERALIGHTING = 5;
    static final int MAXLIGHTS = 6;
    static final int MAXVIEWPORTDIMENSION = 7;
    static final int MAXTEXTUREDIMENSION = 8;
    static final int MAXSPRITECROPDIMENSION = 9;
    static final int NUMTEXTUREUNITS = 10;
    static final int MAXTRANSFORMSPERVERTEX = 11;
    static final int MAXVIEWPORTWIDTH = 12;
    static final int MAXVIEWPORTHEIGHT = 13;
    private static Graphics3D instance;
    private Object boundTarget = null;
    private boolean isGraphics = true;
    private boolean preload = true;
    private static Hashtable properties;
    private int clipX = 0;
    private int clipY = 0;
    private int clipWidth = 0;
    private int clipHeight = 0;
    private int viewportX = 0;
    private int viewportY = 0;
    private int viewportWidth = 0;
    private int viewportHeight = 0;
    private static int maxViewportWidth;
    private static int maxViewportHeight;
    static /* synthetic */ Class class$javax$microedition$m3g$Graphics3D;

    private native void finalize();

    Graphics3D() {
    }

    Graphics3D(int handle) {
        this.swerveHandle = handle;
    }

    public native float getDepthRangeNear();

    public native float getDepthRangeFar();

    public native boolean isDepthBufferEnabled();

    public native int getHints();

    public native int getLightCount();

    private static native int createImpl();

    public static final Graphics3D getInstance() {
        if (instance == null) {
            instance = (Graphics3D)Engine.instantiateJavaPeer(Graphics3D.createImpl());
            maxViewportWidth = Graphics3D.getCapability(12);
            maxViewportHeight = Graphics3D.getCapability(13);
        }
        return instance;
    }

    private native void setBackBufferImage2D(Image2D var1);

    private native void setHints(boolean var1, int var2);

    public Object getTarget() {
        return this.boundTarget;
    }

    public synchronized void bindTarget(Object target, boolean depthBuffer, int hints) {
        if (this.boundTarget != null) {
            throw new IllegalStateException();
        }
        if (target == null) {
            throw new NullPointerException();
        }
        if ((hints & 0xFFFFFFE1) != 0) {
            throw new IllegalArgumentException();
        }
        if (target instanceof Graphics) {
            this.isGraphics = true;
            this.preload = (hints & 0x10) == 0;
            this.bindTarget((Graphics)target);
        } else if (target instanceof Image2D) {
            this.isGraphics = false;
            this.setBackBufferImage2D((Image2D)target);
            this.boundTarget = target;
        } else {
            throw new IllegalArgumentException();
        }
        this.setHints(depthBuffer, hints);
    }

    public synchronized void bindTarget(Object target) {
        if (this.boundTarget != null) {
            throw new IllegalStateException();
        }
        if (target == null) {
            throw new NullPointerException();
        }
        if (target instanceof Graphics) {
            this.isGraphics = true;
            this.preload = true;
            this.bindTarget((Graphics)target);
        } else if (target instanceof Image2D) {
            this.isGraphics = false;
            this.setBackBufferImage2D((Image2D)target);
            this.boundTarget = target;
        } else {
            throw new IllegalArgumentException();
        }
    }

    private void bindTarget(Graphics g) {
        this.clipX = g.getTranslateX() + g.getClipX();
        this.clipY = g.getTranslateY() + g.getClipY();
        this.clipWidth = g.getClipWidth();
        this.clipHeight = g.getClipHeight();
        if (this.clipWidth > maxViewportWidth || this.clipHeight > maxViewportHeight) {
            throw new IllegalArgumentException();
        }
        this.boundTarget = g;
        this.bindTargetGraphics(g, this.clipX, this.clipY, this.clipWidth, this.clipHeight);
    }

    private native void bindTargetGraphics(Graphics var1, int var2, int var3, int var4, int var5);

    public synchronized void releaseTarget() {
        if (this.boundTarget == null) {
            return;
        }
        if (this.isGraphics) {
            this.releaseTargetGraphics((Graphics)this.boundTarget);
        } else {
            this.setBackBufferImage2D(null);
        }
        this.boundTarget = null;
    }

    private native void releaseTargetGraphics(Graphics var1);

    public void setViewport(int x, int y, int width, int height) {
        if (width <= 0 || width > maxViewportWidth || height <= 0 || height > maxViewportHeight) {
            throw new IllegalArgumentException();
        }
        this.viewportX = x;
        this.viewportY = y;
        this.viewportWidth = width;
        this.viewportHeight = height;
        if (this.boundTarget != null) {
            if (this.boundTarget instanceof Graphics) {
                Graphics g = (Graphics)this.boundTarget;
                this.preload = this.preload && ((x += g.getTranslateX()) > this.clipX || x + width < this.clipX + this.clipWidth || (y += g.getTranslateY()) > this.clipY || y + height < this.clipY + this.clipHeight);
                this.setViewportImpl(x, y, width, height);
                this.preload = false;
            } else {
                this.setViewportImpl(x, y, width, height);
            }
        }
    }

    private native void setViewportImpl(int var1, int var2, int var3, int var4);

    public int getViewportX() {
        return this.viewportX;
    }

    public int getViewportY() {
        return this.viewportY;
    }

    public int getViewportWidth() {
        return this.viewportWidth;
    }

    public int getViewportHeight() {
        return this.viewportHeight;
    }

    public native void setDepthRange(float var1, float var2);

    private native void clearImpl(Background var1);

    public synchronized void clear(Background background) {
        if (this.boundTarget == null) {
            throw new IllegalStateException();
        }
        this.preload = this.preload && background != null && !background.isColorClearEnabled();
        this.clearImpl(background);
        this.preload = false;
    }

    public void render(VertexBuffer vertices, IndexBuffer triangles, Appearance appearance, Transform transform) {
        this.render(vertices, triangles, appearance, transform, -1);
    }

    private native void renderPrimitive(VertexBuffer var1, IndexBuffer var2, Appearance var3, Transform var4, int var5);

    public synchronized void render(VertexBuffer vertices, IndexBuffer triangles, Appearance appearance, Transform transform, int scope) {
        if (this.boundTarget == null) {
            throw new IllegalStateException();
        }
        this.renderPrimitive(vertices, triangles, appearance, transform, scope);
        this.preload = false;
    }

    private native void renderNode(Node var1, Transform var2);

    public synchronized void render(Node node, Transform transform) {
        if (this.boundTarget == null) {
            throw new IllegalStateException();
        }
        this.renderNode(node, transform);
        this.preload = false;
    }

    private native void renderWorld(World var1);

    public synchronized void render(World world) {
        if (this.boundTarget == null) {
            throw new IllegalStateException();
        }
        Background background = world.getBackground();
        this.preload = this.preload && background != null && !background.isColorClearEnabled();
        this.renderWorld(world);
        this.preload = false;
    }

    public Camera getCamera(Transform transform) {
        Camera __res = (Camera)Engine.instantiateJavaPeer(this.getCameraImpl(transform));
        return __res;
    }

    private native int getCameraImpl(Transform var1);

    public void setCamera(Camera camera, Transform transform) {
        this.setCameraImpl(camera, transform);
        Engine.addXOT(camera);
    }

    private native void setCameraImpl(Camera var1, Transform var2);

    public void setLight(int index, Light light, Transform transform) {
        this.setLightImpl(index, light, transform);
        Engine.addXOT(light);
    }

    private native void setLightImpl(int var1, Light var2, Transform var3);

    public Light getLight(int index, Transform transform) {
        Light __res = (Light)Engine.instantiateJavaPeer(this.getLightImpl(index, transform));
        return __res;
    }

    private native int getLightImpl(int var1, Transform var2);

    public int addLight(Light light, Transform transform) {
        int __res = this.addLightImpl(light, transform);
        Engine.addXOT(light);
        return __res;
    }

    private native int addLightImpl(Light var1, Transform var2);

    public native void resetLights();

    public static final synchronized Hashtable getProperties() {
        if (properties == null) {
            properties = new Hashtable();
            properties.put(new String("supportAntialiasing"), new Boolean(Graphics3D.getCapability(0) == 1));
            properties.put(new String("supportTrueColor"), new Boolean(Graphics3D.getCapability(1) == 1));
            properties.put(new String("supportDithering"), new Boolean(Graphics3D.getCapability(2) == 1));
            properties.put(new String("supportMipmapping"), new Boolean(Graphics3D.getCapability(3) == 1));
            properties.put(new String("supportPerspectiveCorrection"), new Boolean(Graphics3D.getCapability(4) == 1));
            properties.put(new String("supportLocalCameraLighting"), new Boolean(Graphics3D.getCapability(5) == 1));
            properties.put(new String("maxLights"), new Integer(Graphics3D.getCapability(6)));
            properties.put(new String("maxViewportDimension"), new Integer(Graphics3D.getCapability(7)));
            properties.put(new String("maxTextureDimension"), new Integer(Graphics3D.getCapability(8)));
            properties.put(new String("maxSpriteCropDimension"), new Integer(Graphics3D.getCapability(9)));
            properties.put(new String("numTextureUnits"), new Integer(Graphics3D.getCapability(10)));
            properties.put(new String("maxTransformsPerVertex"), new Integer(Graphics3D.getCapability(11)));
            properties.put(new String("maxViewportWidth"), new Integer(maxViewportWidth));
            properties.put(new String("maxViewportHeight"), new Integer(maxViewportHeight));
            properties.put(new String("C3A458D3-2015-41f5-8338-66A2D3014335"), Engine.getVersionMajor() + "." + Engine.getVersionMinor() + "." + Engine.getRevisionMajor() + "." + Engine.getRevisionMinor() + ":" + Engine.getBranchNumber());
            try {
                properties.put(new String("com.superscape.m3gx.DebugUtils"), Class.forName("javax.microedition.m3g.DebugUtils").newInstance());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return properties;
    }

    private static native int getCapability(int var0);

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Engine.cacheFID(class$javax$microedition$m3g$Graphics3D == null ? (class$javax$microedition$m3g$Graphics3D = Graphics3D.class$("javax.microedition.m3g.Graphics3D")) : class$javax$microedition$m3g$Graphics3D, 1);
        instance = null;
        properties = null;
        maxViewportWidth = 0;
        maxViewportHeight = 0;
    }
}

