/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.m2g;

import com.sun.perseus.j2d.RGB;
import com.sun.perseus.j2d.RenderGraphics;
import com.sun.perseus.model.DirtyAreaManager;
import com.sun.perseus.model.DocumentNode;
import com.sun.perseus.model.ModelNode;
import com.sun.perseus.model.UpdateListener;
import com.sun.perseus.model.Viewport;
import com.sun.pisces.GraphicsSurfaceDestination;
import com.sun.pisces.NativeSurface;
import com.sun.pisces.PiscesRenderer;
import com.sun.pisces.Surface;
import javax.microedition.lcdui.Graphics;
import javax.microedition.m2g.SVGImage;
import javax.microedition.m2g.ScalableImage;

public class ScalableGraphics {
    static final RGB CLEAR_PAINT = new RGB(0, 0, 0, 0);
    Graphics g = null;
    GraphicsSurfaceDestination gsd = null;
    int qualityMode = 2;
    DirtyAreaManager dirtyAreaManager = new DirtyAreaManager(null);
    float alpha = 1.0f;
    NativeSurface offscreen;
    PiscesRenderer pr;
    int offscreenWidth;
    int offscreenHeight;
    RenderGraphics rg;
    public static final int RENDERING_QUALITY_LOW = 1;
    public static final int RENDERING_QUALITY_HIGH = 2;

    private ScalableGraphics() {
    }

    public void bindTarget(Object target) {
        if (target == null) {
            throw new NullPointerException();
        }
        if (!(target instanceof Graphics)) {
            throw new IllegalArgumentException();
        }
        if (this.g != null) {
            throw new IllegalStateException("bindTarget(" + target + ") with g : " + this.g);
        }
        this.g = (Graphics)target;
        this.gsd = new GraphicsSurfaceDestination(this.g);
    }

    public void releaseTarget() {
        if (this.g == null) {
            throw new IllegalStateException("releaseTarget() with null current target");
        }
        this.g = null;
        this.gsd = null;
    }

    public void render(int x, int y, ScalableImage image) {
        if (image == null) {
            throw new NullPointerException();
        }
        if (this.g == null) {
            throw new IllegalStateException();
        }
        DocumentNode documentNode = (DocumentNode)((SVGImage)image).getDocument();
        int vpw = image.getViewportWidth();
        int vph = image.getViewportHeight();
        this.checkOffscreen(vpw, vph);
        if (DirtyAreaManager.ON) {
            this.dirtyAreaManager.setViewport((Viewport)documentNode);
            documentNode.setUpdateListener((UpdateListener)this.dirtyAreaManager);
        }
        this.rg.setRenderingQuality(this.qualityMode == 2);
        documentNode.sample(documentNode.getCurrentTime());
        documentNode.applyAnimations();
        if (DirtyAreaManager.ON) {
            this.dirtyAreaManager.refresh((ModelNode)documentNode, this.rg, CLEAR_PAINT);
        } else {
            this.pr.setColor(0, 0, 0, 0);
            this.pr.setClip(0, 0, this.offscreenWidth, this.offscreenHeight);
            this.pr.clearRect(0, 0, this.offscreenWidth, this.offscreenHeight);
            documentNode.paint(this.rg);
        }
        this.gsd.drawSurface((Surface)this.offscreen, 0, 0, x, y, this.offscreenWidth, this.offscreenHeight, this.alpha);
    }

    void checkOffscreen(int width, int height) {
        int w = width;
        int h = height;
        if (w <= 0) {
            w = 1;
        }
        if (h <= 0) {
            h = 1;
        }
        if (this.offscreen == null || this.offscreenWidth != w || this.offscreenHeight != h) {
            this.offscreen = new NativeSurface(w, h);
            this.offscreenWidth = w;
            this.offscreenHeight = h;
            this.pr = new PiscesRenderer((Object)this.offscreen, w, h, 0, w, 1, 2);
            this.rg = new RenderGraphics(this.pr, this.offscreenWidth, this.offscreenHeight);
        }
    }

    public void setRenderingQuality(int mode) {
        if (mode != 1 && mode != 2) {
            throw new IllegalArgumentException("" + mode);
        }
        this.qualityMode = mode;
    }

    public void setTransparency(float alpha) {
        if (alpha < 0.0f || alpha > 1.0f) {
            throw new IllegalArgumentException();
        }
        this.alpha = alpha;
    }

    public static ScalableGraphics createInstance() {
        return new ScalableGraphics();
    }
}

